clear variables; close all; clc;

Dataset={'PJM','NP'};
for j=1:length(Dataset)
    
dataset = Dataset{j};

fday = 365; %first estimation day (cal_window_len = 364)
lday = 1092;

fday = (fday - 1) * 24 +1;
lday = lday * 24;

data = importdata(['./DATA/' dataset '.csv']);
p = data.data(fday:lday,1); %real prices from model calibration window


%% load predicted prices with LTSC VST[SD(x)]
lasso_method = 'LASSO1';
ltsc = 'db4';

ltsc_params = 9;
mae_lasso1 = zeros(1,ltsc_params);
rmse_lasso1 = zeros(1,ltsc_params);
phs_lasso1 =[];
for i = 1:ltsc_params
    ph = importdata(['./' lasso_method '_' ltsc '_' num2str(i-1) '_cv7_' dataset '/'...
        dataset '_forecasts.csv']); %predicted prices
    ph=ph(1:2*364*24); 
    phs_lasso1 = [phs_lasso1 ph];
end

%% load predicted prices with LTSC SD[VST(x)]
lasso_method = 'LASSO2';

mae_lasso2 = zeros(ltsc_params);
rmse_lasso2 = zeros(ltsc_params);
phs_lasso2 =[];
for i = 1:ltsc_params
    ph = importdata(['./' lasso_method '_' ltsc '_' num2str(i-1) '_cv7_' dataset '/'...
        dataset '_forecasts.csv']); %predicted prices
    ph=ph(1:2*364*24); 
    phs_lasso2 = [phs_lasso2 ph];
end

phs_com=[phs_lasso1, phs_lasso2];


[A,it,rmse_weights_BMA] = get_parameters_all_methods(p,phs_com);


%BC
save(['methods/BC_LASSO_' dataset '_' ltsc '.mat'],'it','A')
%BMA
save(['methods/BMA_LASSO_' dataset '_' ltsc '.mat'],'rmse_weights_BMA','A')
end
