function [A,it,rmse_weights_BMA] = get_parameters_all_methods(p,ph)

A=dec2bin(0:2^size(ph,2)-1)-'0'; %contains all possible combinations of indexes; each row corresponds to one combination
A=A(2:end,:); %removing the first combination that contains all zeros

indexes=1:size(ph,2);

mae=zeros(1,length(A)); %MAE for each combination
rmse=zeros(1,length(A));%RMSE for each combination
for i=1:length(A)
    cur_ind=indexes(logical(A(i,:)));
    
    cur_ph=ph(:,cur_ind); %forecasts for chosen combination
    cur_ph_mean=mean(cur_ph,2); %simple average of forecasts
    [mae(i),rmse(i)] = return_errors(p,cur_ph_mean);  % RMSE for chosen combination
end

%%for BC
[val_rmse_mean,it]=min(rmse);
it=indexes(logical(A(it,:))); %chosen types of LTSC for BC
%%for BMA 
rmse_weights_BMA=1./rmse; %RMSE weights for BMA
end

