close all; clear variables; clc;
Dataset={'PJM','NP'};
for i=1:length(Dataset)
dataset = Dataset{i};

fday = 365; %first estimation day (cal_window_len = 364)
lday = 1092;

fday = (fday - 1) * 24 +1;
lday = lday * 24;

data = importdata(['./DATA/' dataset '.csv']);
p1 = data.data(fday:lday,1); 

fday = 728 + 365; %first estimation day (cal_window_len = 364)
lday = 2184;

fday = (fday - 1) * 24 +1;
lday = lday * 24;
data = importdata(['./DATA/' dataset '.csv']); 
p2 = data.data(fday:lday,1); %real prices for the model evaluation window

ltsc = 'db4';
ltsc_params = 9;

%% load predicted prices with LTSC VST[SD(x)]
lasso_method = 'LASSO1';
mae_lasso1 = zeros(1,ltsc_params);
rmse_lasso1 = zeros(1,ltsc_params);
phs_lasso1 =[];
for i = 1:ltsc_params
    ph = importdata(['../predictions/lasso/' lasso_method '_' ltsc '_' num2str(i-1) '_cv7_' dataset '/'...
       dataset '_forecasts.csv']); %predicted prices
    ph=ph(2*364*24+1:end); 
    phs_lasso1 = [phs_lasso1 ph];
end

%% load predicted prices with LTSC SD[VST(x)]
lasso_method = 'LASSO2';

mae_lasso2 = zeros(ltsc_params);
rmse_lasso2 = zeros(ltsc_params);
phs_lasso2 =[];
for i = 1:ltsc_params
    ph = importdata(['../predictions/lasso/' lasso_method '_' ltsc '_' num2str(i-1) '_cv7_' dataset '/'...
       dataset '_forecasts.csv']); %predicted prices
    ph=ph(2*364*24+1:end); 
    phs_lasso2 = [phs_lasso2 ph];
end
phs12=[phs_lasso1, phs_lasso2];

%BC
load(['./methods/BC_LASSO_' dataset '_' ltsc '.mat'])
ph_ave_rmse_best=mean(phs12(:,it),2);
dlmwrite(['predictions/' dataset '_LASSO_' ltsc '_BC.csv'], ph_ave_rmse_best,'precision', 9)

%BMA
load(['./methods/BMA_LASSO_' dataset '_' ltsc '.mat'])
ph_BMA=0;
for i=1:length(A)
    curr_ph=phs12(:,logical(A(i,:)));
    ave_curr_hp2=mean(curr_ph,2);%chose combination mean
    ph_BMA=ph_BMA+ave_curr_hp2*rmse_weights_BMA(i);
end
norm=sum(rmse_weights_BMA);
ph_BMA=ph_BMA/norm;

dlmwrite(['predictions/' dataset '_LASSO_' ltsc '_BMA.csv'], ph_BMA,'precision', 9)
end